using System.Collections;
using System.Collections.Generic;
using UnityEngine;

[RequireComponent(typeof(Rigidbody2D))]
public class Asteroid : MonoBehaviour {

    static public List<Asteroid> Alive = new List<Asteroid>();
    static public int destroyedAsteroids = 0;

    public GameObject particleDestroy;
    public AudioClip  audioOnDestroy;

    public GameObject[] debrisPrefabs;
    public int maxDebrisSpawn = 2;

    private Rigidbody2D physicsBody;

    public void SpawnDebris() {
        destroyedAsteroids += 1;
        AudioSource.PlayClipAtPoint(audioOnDestroy, transform.position);

        var particle = Instantiate(particleDestroy);
        particle.transform.position = transform.position;

        if (debrisPrefabs.Length <= 0 || maxDebrisSpawn <= 0) return;

        var spawnCount = Random.Range(1, maxDebrisSpawn);
        for (int i = 0; i < spawnCount; i++) {
            var debrisIndex = Random.Range(0, debrisPrefabs.Length-1);
            var instance = Instantiate(debrisPrefabs[debrisIndex], transform.parent);
            var debrisPhysicsBody = instance.GetComponent<Rigidbody2D>();

            debrisPhysicsBody.rotation = Random.Range(0, 360);
            debrisPhysicsBody.velocity = physicsBody.velocity;
            debrisPhysicsBody.AddForce(Random.insideUnitCircle.normalized * Random.Range(10,20));

            instance.transform.position = transform.position + (Vector3)Random.insideUnitCircle.normalized * .6f;
        }
    }

    void Start() {
        physicsBody = GetComponent<Rigidbody2D>();
        physicsBody.AddForce(Random.insideUnitCircle * Random.Range(10,40));

        Alive.Add(this);
    }

    void OnDestroy() {
        Debug.Log("Asteroid zničený!");
        Alive.Remove(this);
    }

}
