using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;

[RequireComponent(typeof(SpriteRenderer))]
public class AsteroidsGameWon : MonoBehaviour {

    public AudioClip audioClip;
    private SpriteRenderer spriteRenderer;

    private bool triggered = false;

    void Start() {
        spriteRenderer = GetComponent<SpriteRenderer>();
    }

    void Update() {
        if (Asteroid.Alive.Count > 0) return;

        spriteRenderer.enabled = true;

        if (!triggered) {
            triggered = true;
            AudioSource.PlayClipAtPoint(audioClip, transform.position);
        }

        if (Input.GetKeyDown(KeyCode.Return)) SceneManager.LoadScene(0);
    }

}
