using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;

[RequireComponent(typeof(SpriteRenderer))]
public class GameOver : MonoBehaviour {
    
    public AudioClip audioClip;
    private SpriteRenderer spriteRenderer;
    private bool waitForKey = false;

    public void OnPlayerDied() {
        AudioSource.PlayClipAtPoint(audioClip, transform.position);

        spriteRenderer.enabled = true;
        waitForKey = true;
    }

    void Start() {
        spriteRenderer = GetComponent<SpriteRenderer>();
    }

    void Update() {
        if (!waitForKey) return;

        if (Input.GetKeyDown(KeyCode.Return)) {
            Asteroid.destroyedAsteroids = 0;
            SceneManager.LoadScene(0);
        }
    }

}
