using UnityEngine;

[RequireComponent(typeof(Rigidbody2D))]
public class Projectile : MonoBehaviour {

    const float MaxLifetime = 5f;

    Rigidbody2D physicsBody;

    private float lifetime;

    void Start() {
        physicsBody = GetComponent<Rigidbody2D>();
    }

    void OnCollisionEnter2D(Collision2D collision) {
        var target = collision.gameObject.GetComponent<Asteroid>();

        if (target) {
            target.SpawnDebris();
            
            Destroy(collision.gameObject);
            Destroy(gameObject);            
        }
    }

    void Update() {
        lifetime += Time.deltaTime;

        if (lifetime > MaxLifetime)
            Destroy(gameObject);
    }

}
