using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Events;

[RequireComponent(typeof(Rigidbody2D))]
public class Rocket : MonoBehaviour {

    public GameObject projectilePrefab;
    public AudioClip audioOnDestroy;

    public float forwardForce  = 2;
    public float rotationForce = 1;
    public float fireForce     = 200;

    public UnityEvent onDestroyed;
    public LayerMask  asteroidLayerMask;

    Rigidbody2D physicsBody;

    void Start() {
        physicsBody = GetComponent<Rigidbody2D>();
    }

    void Update() {
        // Streľba
        if (Input.GetKeyDown(KeyCode.Space)) {
            var projectileInstance = Instantiate(projectilePrefab);
            projectileInstance.transform.position = (Vector3)(physicsBody.position) + transform.up * 0.7f;
            projectileInstance.transform.rotation = transform.rotation;

            var projectilePhysicsBody = projectileInstance.GetComponent<Rigidbody2D>();

            projectilePhysicsBody.velocity = (Vector3)(physicsBody.velocity);
            projectilePhysicsBody.AddForce(transform.up * fireForce);
        }
    }

    void FixedUpdate() {
        // Prečítanie vstupu z klávesnice
        var forward = Input.GetKey(KeyCode.UpArrow);
        var left    = Input.GetKey(KeyCode.LeftArrow);
        var right   = Input.GetKey(KeyCode.RightArrow);

        // Aplikovanie sily na simulovaný objekt
        if (forward)
            physicsBody.AddForce(transform.up * forwardForce);

        if (left)
            physicsBody.AddTorque(rotationForce);

        if (right)
            physicsBody.AddTorque(-rotationForce);
    }

    void OnCollisionEnter2D(Collision2D collision) {
        if ((collision.gameObject.layer & asteroidLayerMask) == 0) {
            AudioSource.PlayClipAtPoint(audioOnDestroy, transform.position);
            
            Destroy(gameObject);
            onDestroyed.Invoke();
        }
    }

}
